// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit
import MSSOrchestration

class GetInformationViewController: UIViewController {
    @IBOutlet weak var userIdentifierLbl: UILabel!
    @IBOutlet weak var userIdentifier: UILabel!
    @IBOutlet weak var serialNumberLbl: UILabel!
    @IBOutlet weak var serialNumber: UILabel!
    @IBOutlet weak var sequenceNumberUnprotectedLbl: UILabel!
    @IBOutlet weak var sequenceNumberUnprotected: UILabel!
    @IBOutlet weak var sequenceNumberProtectedLbl: UILabel!
    @IBOutlet weak var sequenceNumberProtected: UILabel!
    @IBOutlet weak var usedTimeLbl: UILabel!
    @IBOutlet weak var usedTime: UILabel!
    @IBOutlet weak var timeShiftLbl: UILabel!
    @IBOutlet weak var timeShift: UILabel!
    
    private let orchestrationDelegate = OrchestrationSampleDelegate()

    private var orchestrator: Orchestrator?
    private var progressDialog: UIView?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
        setupOrchestration()
        
        guard let activatedUser = SharedPreferenceStorage.getActivatedUser() else {
            assertionFailure("can't retrieve activated user")
            return
        }
        
        updateView(user: activatedUser)
    }
    
    // MARK: Setup
    private func setupView() {
        title = "title_activity_get_information".localized
        userIdentifierLbl.text = "get_information_user_identifier".localized
        serialNumberLbl.text = "get_information_serial_number".localized
        sequenceNumberUnprotectedLbl.text = "get_information_sequence_number_unprotected".localized
        sequenceNumberProtectedLbl.text = "get_information_sequence_number_protected".localized
        usedTimeLbl.text = "get_information_sequence_used_time".localized
        timeShiftLbl.text = "get_information_sequence_time_shift".localized
    }
    
    private func setupOrchestration() {
        orchestrationDelegate.progressDialog = progressDialog
        orchestrationDelegate.viewController = self
        orchestrator = OrchestratorUtils.getOrchestrator(delegate: orchestrationDelegate, collectCDDC: false)
    }
    
    private func updateView(user: String) {
        do {
            let userInfo = try orchestrator?.userManager.userInformation(for: OrchestrationUser(identifier: user, domain: nil))
            userIdentifier.text = userInfo?.userIdentifier
            serialNumber.text = userInfo?.digipassSerialNumber
            sequenceNumberUnprotected.text = String(format: "%d",
                                                    (userInfo?.digipassSequenceNumberUnprotected) ?? "")
            sequenceNumberProtected.text = String(format: "%d",
                                                  (userInfo?.digipassSequenceNumberProtected) ?? "")
            guard let usedTimeInSeconds = userInfo?.usedTimeSeconds else {
                assertionFailure("usedTimeSeconds in userInfo is nil")
                return
            }
            let date = Date(timeIntervalSince1970: Double(usedTimeInSeconds))
            let formatter = DateFormatter()
            formatter.dateFormat = "yyyy/MM/dd HH:mm:ss"
            usedTime.text = formatter.string(from: date)
            timeShift.text = String(format: "%d", (userInfo?.clientServerTimeShiftSeconds) ?? "")
        } catch {
            print(error)
        }
    }
}
